// ED256Doc.cpp : implementation of the CED256Doc class
//

#include "stdafx.h"
#include "ED256.h"

#include "ED256Doc.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CED256Doc

IMPLEMENT_DYNCREATE(CED256Doc, CDocument)

BEGIN_MESSAGE_MAP(CED256Doc, CDocument)
	//{{AFX_MSG_MAP(CED256Doc)
		// NOTE - the ClassWizard will add and remove mapping macros here.
		//    DO NOT EDIT what you see in these blocks of generated code!
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CED256Doc construction/destruction

CED256Doc::CED256Doc() {
	m_hDIB = NULL;
	m_palDIB = NULL;
}

CED256Doc::~CED256Doc() {}

BOOL CED256Doc::OnNewDocument() {
	if (!CDocument::OnNewDocument())
		return FALSE;

	// Just in case...
	m_hDIB = NULL;
	m_palDIB = NULL;

	return TRUE;
}



/////////////////////////////////////////////////////////////////////////////
// CED256Doc serialization

void CED256Doc::Serialize(CArchive& ar) {
	if (ar.IsStoring()) {
		// TODO: add storing code here
	} else {
		// TODO: add loading code here
	}
}

/////////////////////////////////////////////////////////////////////////////
// CED256Doc diagnostics

#ifdef _DEBUG
void CED256Doc::AssertValid() const {
	CDocument::AssertValid();
}

void CED256Doc::Dump(CDumpContext& dc) const {
	CDocument::Dump(dc);
}
#endif //_DEBUG

BOOL CED256Doc::OnOpenDocument(LPCTSTR lpszPathName) {
	if (!CDocument::OnOpenDocument(lpszPathName))
		return FALSE;
	
	CFile file;
	if (!file.Open(lpszPathName, CFile::modeRead)) {
		AfxMessageBox("Problem opening file.");
	}

	m_hDIB = ::ReadDIBFile(file);

	InitDIBData();
	if (!m_hDIB) {
		AfxMessageBox("Error reading DIB section.");
	}
	
	return TRUE;
}

void CED256Doc::InitDIBData() {
	if (m_palDIB != NULL) {
		delete m_palDIB;
		m_palDIB = NULL;
	}
	if (m_hDIB == NULL) {
		return;
	}
	// Set up document size
	LPSTR lpDIB = (LPSTR) ::GlobalLock((HGLOBAL) m_hDIB);
	::GlobalUnlock((HGLOBAL) m_hDIB);

	m_palDIB = new CPalette;
	if (m_palDIB == NULL) {
		::GlobalFree((HGLOBAL) m_hDIB);
		m_hDIB = NULL;
		return;
	}
	if (::CreateDIBPalette(m_hDIB, m_palDIB) == NULL) {
		// DIB may not have a palette
		delete m_palDIB;
		m_palDIB = NULL;
		return;
	}
}

HDIB CED256Doc::GetHDIB() {
	return m_hDIB;
}

CPalette *CED256Doc::GetDocPalette() {
	return m_palDIB;
}
