// MainFrm.cpp : implementation of the CMainFrame class
//

#include "stdafx.h"
#include "ED256.h"

#include "MainFrm.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CMainFrame

IMPLEMENT_DYNCREATE(CMainFrame, CFrameWnd)

BEGIN_MESSAGE_MAP(CMainFrame, CFrameWnd)
	//{{AFX_MSG_MAP(CMainFrame)
		// NOTE - the ClassWizard will add and remove mapping macros here.
		//    DO NOT EDIT what you see in these blocks of generated code !
	ON_WM_CREATE()
	ON_MESSAGE(WM_USER+0x0001, ThreshChange)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

static UINT indicators[] =
{
	ID_SEPARATOR,           // status line indicator
	ID_INDICATOR_CAPS,
	ID_INDICATOR_NUM,
	ID_INDICATOR_SCRL,
};

/////////////////////////////////////////////////////////////////////////////
// CMainFrame construction/destruction

CMainFrame::CMainFrame() {
	m_iThreshold = 20;
}

CMainFrame::~CMainFrame() {}

int CMainFrame::OnCreate(LPCREATESTRUCT lpCreateStruct) {
	if (CFrameWnd::OnCreate(lpCreateStruct) == -1) return -1;
	
	if (!m_wndToolBar.Create(this) ||
		!m_wndToolBar.LoadToolBar(IDR_MAINFRAME)) {
		TRACE0("Failed to create toolbar\n");
		return -1;
	}

	if (!m_wndProtoBar.Create(this) ||
		!m_wndProtoBar.LoadToolBar(IDR_PROTOTYPING)) {
		TRACE0("Failed to create prototyping toolbar\n");
		return -1;
	}

	if (!m_wndStatusBar.Create(this) ||
		!m_wndStatusBar.SetIndicators(indicators,
		  sizeof(indicators)/sizeof(UINT))) {
		TRACE0("Failed to create status bar\n");
		return -1;
	}

	m_wndToolBar.SetBarStyle(m_wndToolBar.GetBarStyle() |
		CBRS_TOOLTIPS | CBRS_FLYBY | CBRS_SIZE_DYNAMIC);
	m_wndProtoBar.SetBarStyle(m_wndProtoBar.GetBarStyle() |
		CBRS_TOOLTIPS | CBRS_FLYBY | CBRS_SIZE_DYNAMIC);

	m_wndToolBar.EnableDocking(CBRS_ALIGN_ANY);
	m_wndProtoBar.EnableDocking(CBRS_ALIGN_ANY);
	EnableDocking(CBRS_ALIGN_ANY);
	DockControlBar(&m_wndToolBar);
	DockControlBarLeftOf(&m_wndProtoBar, &m_wndToolBar);

	int ind = m_wndToolBar.CommandToIndex(ID_THRESHEDIT);
	m_wndToolBar.SetButtonInfo(ind, ID_THRESHEDIT, TBBS_SEPARATOR, 40);

	CRect rect;
	m_wndToolBar.GetItemRect(ind,&rect);
	if (!m_wndToolBar.m_cEdit.Create(WS_VISIBLE | WS_CHILD | WS_BORDER, rect,
		&m_wndToolBar, ID_THRESHEDIT)) {
		TRACE0("Failed to create edit control! Damn...");
		return -1;
	}

	m_cFont.CreatePointFont(100, "Tahoma");
	m_wndToolBar.m_cEdit.SetFont(&m_cFont, true);

	CString str; str.Format("%d",m_iThreshold);
	m_wndToolBar.m_cEdit.SetWindowText(str);

	return 0;
}

BOOL CMainFrame::PreCreateWindow(CREATESTRUCT& cs)
{
	// TODO: Modify the Window class or styles here by modifying
	//  the CREATESTRUCT cs

	return CFrameWnd::PreCreateWindow(cs);
}

/////////////////////////////////////////////////////////////////////////////
// CMainFrame diagnostics

#ifdef _DEBUG
void CMainFrame::AssertValid() const
{
	CFrameWnd::AssertValid();
}

void CMainFrame::Dump(CDumpContext& dc) const
{
	CFrameWnd::Dump(dc);
}

#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CMainFrame message handlers

CToolBar *CMainFrame::GetToolbar() {
	return &m_wndToolBar;
}

LRESULT CMainFrame::ThreshChange(WPARAM wparam, LPARAM lparam) {
	m_iThreshold = (int)(wparam);	

	return 0;
}

void CMainFrame::DockControlBarLeftOf(CToolBar* Bar, CToolBar* LeftOf) {
	// From DOCKTOOL Sample

	CRect rect;
	DWORD dw;
	UINT n;

	// get MFC to adjust the dimensions of all docked ToolBars
	// so that GetWindowRect will be accurate
	RecalcLayout();
	LeftOf->GetWindowRect(&rect);
	rect.OffsetRect(1,0);
	dw=LeftOf->GetBarStyle();
	n = 0;
	n = (dw&CBRS_ALIGN_TOP) ? AFX_IDW_DOCKBAR_TOP : n;
	n = (dw&CBRS_ALIGN_BOTTOM && n==0) ? AFX_IDW_DOCKBAR_BOTTOM : n;
	n = (dw&CBRS_ALIGN_LEFT && n==0) ? AFX_IDW_DOCKBAR_LEFT : n;
	n = (dw&CBRS_ALIGN_RIGHT && n==0) ? AFX_IDW_DOCKBAR_RIGHT : n;

	// When we take the default parameters on rect, DockControlBar will dock
	// each Toolbar on a seperate line.  By calculating a rectangle, we in effect
	// are simulating a Toolbar being dragged to that location and docked.
	DockControlBar(Bar,n,&rect);
}

void CMainFrame::PercentComplete(float percent) {
	CString str;
	str.Format("%.1f percent complete...",percent);

	SetStatusMessage(str);
}

void CMainFrame::SetStatusMessage(UINT uID) {
	CString str;
	str.LoadString(uID);

	SetStatusMessage(str);
}

void CMainFrame::SetStatusMessage(CString str) {
	m_wndStatusBar.SetPaneText(0,str);
}
