//////////////////////////////////////////////////////////////////
// CED256View class (17/10/2000)
// Author: James Matthews
//
// Implements a simple edge detection algorithm and 
// prototyping system.
//
// Written for Generation5 (http://www.generation5.org/)
//
// See http://www.generation5.org/vision.shtml
//     http://www.generation5.org/edgedetect.shtml for details.
//

#ifndef _AFX_ED256VIEW_H_
#define _AFX_ED256VIEW_H_

#if _MSC_VER >= 1000
#pragma once
#endif

#define MAX_PROTOTYPES	10
#define MAX_SAMPLES		1500
#define MAX_PITERATIONS	10000

typedef struct {
	char pixels[15][15];
} _protoBmp;

class CED256View : public CView {

protected: 
	CED256View();
	DECLARE_DYNCREATE(CED256View)

public:
	CED256Doc* GetDocument();

	//{{AFX_VIRTUAL(CED256View)
	public:
	virtual void OnDraw(CDC* pDC);  // overridden to draw this view
	virtual BOOL PreCreateWindow(CREATESTRUCT& cs);
	virtual void OnInitialUpdate();
	//}}AFX_VIRTUAL

public:
	int			m_iOffset;

	COLORREF	m_crPlot, m_crNoPlot;

	virtual		~CED256View();
	static		UINT StartEdgeDetect(void *);

#ifdef _DEBUG
	virtual void AssertValid() const;
	virtual void Dump(CDumpContext& dc) const;
#endif

protected:
	bool	m_bColour, m_bInverse;
	float	m_fFilter[9];
	int		m_iResolution;
	int		m_iFormula;

	COLORREF m_crProtoColours[MAX_PROTOTYPES];

	CBitmap m_bmpEdges;

	bool	Plot(int, int, int, int);
	void	CopyBitmap();
	void	GetDIBSize(int &, int &);
	void	PullDownToolBar(CToolBar *, UINT, UINT, int bold = -1);
	void	UpdateTotals(float &, float &, float &, float, COLORREF);

	//{{AFX_MSG(CED256View)
	afx_msg void OnEditEdgeDetect();
	afx_msg void OnColourType();
	afx_msg void OnFormula();
	afx_msg void OnEditFormulatypeDifferenceand();
	afx_msg void OnEditFormulatypeDifferenceor();
	afx_msg void OnEditFormulatypeSummation();
	afx_msg void OnInverse();
	afx_msg void OnFilter();
	afx_msg void OnUpdateColourtype(CCmdUI* pCmdUI);
	afx_msg void OnUpdateInverse(CCmdUI* pCmdUI);
	afx_msg void OnEditOutputBlackandwhite();
	afx_msg void OnEditOutputColour();
	afx_msg void OnUpdateEditOutputBlackandwhite(CCmdUI* pCmdUI);
	afx_msg void OnUpdateEditOutputColour(CCmdUI* pCmdUI);
	afx_msg void OnUpdateEditFormulatypeDifferenceand(CCmdUI* pCmdUI);
	afx_msg void OnUpdateEditFormulatypeDifferenceor(CCmdUI* pCmdUI);
	afx_msg void OnUpdateEditFormulatypeSummation(CCmdUI* pCmdUI);
	afx_msg BOOL OnEraseBkgnd(CDC* pDC);
	afx_msg void OnEditPrototyping();
	afx_msg void OnChangeResolution();
	afx_msg void OnEditCopy();
	afx_msg void OnUpdateResLow(CCmdUI* pCmdUI);
	afx_msg void OnUpdateResMedium(CCmdUI* pCmdUI);
	afx_msg void OnUpdateResHigh(CCmdUI* pCmdUI);
	//}}AFX_MSG
	afx_msg void OnResolution(UINT);
	DECLARE_MESSAGE_MAP()
};

#ifndef _DEBUG 
inline CED256Doc* CED256View::GetDocument()
   { return (CED256Doc*)m_pDocument; }
#endif

//{{AFX_INSERT_LOCATION}}

#endif
